//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <CoreNFC/CoreNFC.h>
#import "ISO15693Command.h"

@interface NTAG5_NFC_LIB : NSObject <NFCNDEFReaderSessionDelegate, NFCTagReaderSessionDelegate, NFCMiFareTag >

+ (NTAG5_NFC_LIB *) sharedInstance;

/*!
 *@abstract  Checks whether NFC is connected or not
 **/
- (int) isConnect;

/*!
 *@abstract   initializes an NFC session through the NFC Core API
 **/
- (void) initSession:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   Closes the NFC session ongoing with a "Success!"
 **/
- (void) close:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   invalidates the ongoing NFC session by displaying a "Communication error" message
 **/
- (void) errorMessage:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   invalidates the ongoing NFC session by displaying a custom error  message
 *@param message is the error message to display at imvalidating the session
 **/
- (void) customErrorMessage: (NSString *) message message: (void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   sets the message to display at closing the NFC session
 **/
- (void) setMessage: (NSString *) message;

/*!
 *@abstract   sends a custom command to your NTAG 5 following ISO15693 command structure
 *@param command is the ISO15693 command that will be sent
 **/
- (NSData *) sendCommand:(ISO15693Command *) command onSuccess:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   sends a select command to the NTAG 5 using the NFC Core API
 **/
- (void) select:(uint8_t *) flags onSuccess:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

@end

